/**
 * Titel: Quelltext zu Kapitel 19 <br />
 * Buch: Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren: Klaus-Georg Deck und Herbert Neuendorf Copyright: Copyright (c) 2007
 * <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 1.0 <br />
 * 
 */
public class MyInteger {
   private int ival;

   public static int MIN_VALUE = 1 << 31;

   public static int MAX_VALUE = ~(1 << 31);

   public MyInteger(int value) {
      ival = value;
   }

   public MyInteger(String s) {
      ival = string2int(s);
   }

   public int intValue() {
      return ival;
   }

   public String toString() {
      return "" + ival;
   }

   public boolean equals(Object obj) {
      if (obj == null)
         return false;
      if (getClass() != obj.getClass())
         return false;
      return (ival == ((MyInteger) obj).ival);
   }

   private static int string2int(String s) {
      char c;
      int z; // c=gelesene Ziffer, z=deren Zahlenwert
      int k = 1; // 10er Potenz, je nach Stelle
      int erg = 0; // Ergebnis
      int len = s.length(); // Lnge des Strings
      for (int i = 0; i < len; i++) {
         c = s.charAt(len - i - 1);
         if (c < '0' || c > '9')
            throw new NumberFormatException(s);
         z = c - '0'; // Ziffer in Zahl
         erg += z * k; // Aufsummieren
         k *= 10; // nchste 10er Potenz
      }
      return erg;
   }
   
   public static void main( String[] args ){
      System.out.println(new MyInteger(1234));
   }
}
