/**
 * Titel:     Quelltext zu Kapitel 19 <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Herbert Neuendorf<br />
 * @version 1.0 <br />
 * 
 */
public class Preise {
   private double stueckPreis;

   private enum Mengen {
      Klein, Mittel, Gross
   };

   public Preise(double p) {
      stueckPreis = p;
   }

   public double gesamtPreis(int zahl) {
      Mengen m = Mengen.Klein;
      double preis = 0.0;
      if (zahl > 100)
         m = Mengen.Mittel;
      if (zahl > 1000)
         m = Mengen.Gross;
      switch (m) {
      case Klein:
         preis = 1.0 * zahl * stueckPreis;
         break;
      case Mittel:
         preis = 0.9 * zahl * stueckPreis;
         break;
      case Gross:
         preis = 0.8 * zahl * stueckPreis;
         break;
      }
      return preis;
   }

   public static void main(String[] args) {
      Preise tester = new Preise(100.0);
      System.out.println("Preis = " + tester.gesamtPreis(780));
      
      Mengen m = Mengen.Klein;    
      System.out.println( "Inhalt: " + m );       
      System.out.println( "Inhalt: " + Mengen.Mittel + "  " + Mengen.Gross ); 
   }
}