/**
 * Titel:     Quelltext zu Kapitel 19 <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 1.0 <br />
 * 
 */
public class Mitarbeiter implements Comparable{
   private int persNr;
   private String nachname;
   private String vorname; // evtl. noch weitere Attribute
   
   public Mitarbeiter( int persNr, String nachname, String vorname ){
      this.persNr=persNr; this.nachname=nachname; this.vorname=vorname;
   }
   
   public String toString(){
      return persNr + " " + nachname + ", " + vorname;
   }

   public boolean equals(Object obj) {
      if (this == obj)
         return true;
      if (obj == null)
         return false;
      if (getClass() != obj.getClass())
         return false;
      
      
      Mitarbeiter that = (Mitarbeiter) obj;
      if (persNr != that.persNr)
         return false;
      if (!nachname.equals(that.nachname))
         return false;
      if (!vorname.equals(that.vorname))
         return false;

      // alle relevanten Attribute sind nicht verschieden:
      return true;
   }
   
   public int hashCode( ) {       
      int rc = persNr;       
      rc = rc + nachname.hashCode();      
      rc = rc + vorname.hashCode();       
      return rc;    
   } 
   
   public int compareTo( Object obj ) {     
      if( this==obj ) return 0;     
        
      Mitarbeiter that = (Mitarbeiter)obj;     
      
      int cmp;     
      //      erstes Sortierkriterium    
      if( (cmp = nachname.compareTo( that.nachname )) != 0 )       
         return cmp;     
      //      'name' ist gleich, also zweites Sortierkriterium     
      if( (cmp = vorname.compareTo( that.vorname )) != 0 )       
         return cmp;     
      //      'name' und 'vorname sind gleich, also drittes Kriterium     
      if( persNr != that.persNr )       
         return persNr<that.persNr ? -1 : 1;     
      //      in allen Attributen gleich     
      return 0;   
   } 
   
   public static void main( String[] args ) {    
      Mitarbeiter[] m = new Mitarbeiter[3];    
      m[0]=new Mitarbeiter(1006, "Meier", "Rolf");    
      m[1]=new Mitarbeiter(1003, "Meier", "Rolf");    
      m[2]=new Mitarbeiter(1007, "Lang", "Ulla");    
      printArray( m );    
      java.util.Arrays.sort( m );    
      System.out.println("Nach Aufruf von sort():");    
      printArray( m ); } 
   
   public static void printArray( Object[] arr ) {    
      for( int i=0; i<arr.length; i++ )       
         System.out.println( arr[i] ); 
   } 
}
