/**
 * Titel:     Quelltext zu Kapitel 25: Personalverwaltung <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 4.0 <br />
 * 
 */

package de.javawi.personal;
import java.io.Serializable;
import java.util.Comparator;

public class Mitarbeiter implements Serializable, Comparable<Mitarbeiter> {

   private static final long serialVersionUID = 1701439037577201070L;

   private final int persNr;

   private String nachname;

   private String vorname;

   public Mitarbeiter(int persNr, String nachname, String vorname) {
      if( nachname == null || nachname.length() == 0 )
         throw new IllegalArgumentException("Nachname: " + nachname);
      if( vorname == null || vorname.length() == 0 )
         throw new IllegalArgumentException("Vorname: " + vorname);
      this.persNr = persNr;
      this.nachname = nachname;
      this.vorname = vorname;
   }

   public int getPersNr() {
      return persNr;
   }

   public String getNachname() {
      return nachname;
   }

   public String getVorname() {
      return vorname;
   }

   public void setNachname( String nachname ) {
      if( nachname == null || nachname.length() == 0 )
         throw new IllegalArgumentException("Name: " + nachname);
      this.nachname = nachname;
   }

   public void setVorname( String vorname ) {
      if( vorname == null || vorname.length() == 0 )
         throw new IllegalArgumentException("Name: " + vorname);
      this.vorname = vorname;
   }

   public String toString() {
      return persNr + "-" + nachname + "-" + vorname;
   }

   public boolean equals( Object o ) {
      if( this == o )
         return true;
      if( o == null )
         return false;
      if( getClass() != o.getClass() )
         return false;
      return this.persNr == ((Mitarbeiter) o).persNr;
   }

   public int hashCode() {
      return persNr;
   }

   public int compareTo( Mitarbeiter m ) {
      return persNr < m.persNr ? -1 : (persNr > m.persNr ? 1 : 0);
   }

   public static Comparator<Mitarbeiter> NAME_ORDER = new Comparator<Mitarbeiter>() {
      public int compare( Mitarbeiter m1, Mitarbeiter m2 ) {
         int rc = m1.nachname.compareTo(m2.nachname);
         if( rc != 0 )
            return rc;
         rc = m1.vorname.compareTo(m2.vorname);
         return rc != 0 ? rc : m1.compareTo(m2); // bei gleichem Namen
                                                   // entscheidet Personalnummer
      }
   };

   public static void main( String[] args ) { // einige Tests
      Mitarbeiter[] m = new Mitarbeiter[3];
      m[0] = new Mitarbeiter(1009, "Meier", "Udo");
      m[1] = new Mitarbeiter(1006, "Amann", "Iris");
      m[2] = new Mitarbeiter(1000, "Meier", "Volkmar");
      System.out.println(java.util.Arrays.toString(m));
      java.util.Arrays.sort(m);
      System.out.println(java.util.Arrays.toString(m));
      java.util.Arrays.sort(m, NAME_ORDER);
      System.out.println(java.util.Arrays.toString(m));
      System.out.println(new Mitarbeiter(1003, "m", "s")
            .equals(new Mitarbeiter(1003, "d", "s")));
   }
}
