/**
 * Titel:     Quelltext zu Kapitel 25: Personalverwaltung <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 2.0 <br />
 * 
 */

package de.javawi.personal;
import java.util.*;

class MitarbeiterDataTemp implements IMitarbeiterData{
   private final List<Mitarbeiter> mListe = new ArrayList<Mitarbeiter>();
   
   public Mitarbeiter find( int persNr ) {
      Mitarbeiter m=null;
      for (Object o : mListe) {
         if (((Mitarbeiter) o).getPersNr() == persNr) {
            m = (Mitarbeiter) o;
            break;
         }
      }
      return m;
   }
   public void delete( int persNr ) {
      for( Iterator it=mListe.iterator(); it.hasNext(); ){
         if( ((Mitarbeiter)it.next()).getPersNr() == persNr) {
            it.remove();
            return;
         }
      }
      throw new RuntimeException("Mitarbeiter existiert nicht: " + persNr);
   }
   public void insert( Mitarbeiter m ){
      for( Object o : mListe ) {
         Mitarbeiter ma = (Mitarbeiter)o;
         if( ma.getPersNr()==m.getPersNr() )
            throw new MitarbeiterDataException("Fehler in insert(). Personalnummer existiert bereits. " + m.getPersNr());   
      }
      mListe.add( m );
   }
   public void update( Mitarbeiter m ){
      for( Object o : mListe ) {
         Mitarbeiter ma = (Mitarbeiter)o;
         if( ma.getPersNr()==m.getPersNr() ){
            ma.setNachname( m.getNachname() );
            ma.setVorname( m.getVorname() );
            return;
         }
      }
      throw new RuntimeException("Fehler in update(). Mitarbeiter existiert nicht: " + m.getPersNr());     
   }
   public int getCount( ){
      return mListe.size();
   }
   public List<Mitarbeiter> findAll(){
      return mListe;
   }
}

