/**
 * Titel:     Quelltext zu Kapitel 25: Personalverwaltung <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 2.0 <br />
 * 
 */

package de.javawi.personal;
import java.io.*;
import java.util.*;

class MitarbeiterDataFile implements IMitarbeiterData{
   private List<Mitarbeiter> mListe = null;
   private final static String DATA_FILE = "mitarbeiter.dat";
   
   private void readData() throws MitarbeiterDataException {
      File data = new File( DATA_FILE );
      if( !data.exists() ){
         mListe = new ArrayList<Mitarbeiter>();
         return;
      }
      ObjectInputStream oin = null;
      try {
         oin = new ObjectInputStream( new FileInputStream(data) );
         mListe = (List<Mitarbeiter>)oin.readObject();
         oin.close();
      }catch( ClassNotFoundException e ) {
         throw new MitarbeiterDataException( e );
      }catch( FileNotFoundException e ) {
         throw new MitarbeiterDataException( e );
      } catch( IOException e ) {
         throw new MitarbeiterDataException( e );
      }finally{
         if( oin!=null )
            try{ oin.close(); } catch( IOException e ){e.printStackTrace();}
      }
   }
   private void writeData()  {
      File data = new File( DATA_FILE );
      ObjectOutputStream oout=null;
      try {
         oout = new ObjectOutputStream(new FileOutputStream(data));
         oout.writeObject(mListe);
      } catch( FileNotFoundException e ) {
         throw new MitarbeiterDataException(e);
      } catch( IOException e ) {
         throw new MitarbeiterDataException(e);
      }
      finally{
         if( oout!=null )
            try{ oout.close(); } catch( IOException e ){e.printStackTrace();}
      }
   }
   
   public Mitarbeiter find( int persNr )  {
      readData();
      Mitarbeiter m=null;
      for (Object o : mListe) {
         if (((Mitarbeiter) o).getPersNr() == persNr) {
            m = (Mitarbeiter) o;
            break;
         }
      }
      return m;
   }
   public void delete( int persNr ) {
      for( Iterator it=mListe.iterator(); it.hasNext(); ){
         if( ((Mitarbeiter)it.next()).getPersNr() == persNr) {
            it.remove();
            writeData();
            return;
         }
      }
      throw new MitarbeiterDataException("Mitarbeiter existiert nicht: " + persNr);
   }
   public void insert( Mitarbeiter m ) {
      readData();
      for( Object o : mListe ) {
         Mitarbeiter ma = (Mitarbeiter)o;
         if( ma.getPersNr()==m.getPersNr() )
            throw new MitarbeiterDataException("Fehler in insert(). Personalnummer existiert bereits. " + m.getPersNr());   
      }
      mListe.add( m );
      writeData();
   }
   public void update( Mitarbeiter m )  {
      readData();
      for( Object o : mListe ) {
         Mitarbeiter ma = (Mitarbeiter)o;
         if( ma.getPersNr()==m.getPersNr() ){
            ma.setNachname( m.getNachname() );
            ma.setVorname( m.getVorname() );
            writeData();
            return;
         }
      }
      throw new MitarbeiterDataException("Fehler in update(). Mitarbeiter existiert nicht: " + m.getPersNr());     
   }
   public int getCount( )  {
      readData();
      return mListe.size();
   }
   public List<Mitarbeiter> findAll()  {
      readData();
      return mListe;
   }
}

