/**
 * Titel:     Quelltext zu Kapitel 25: Personalverwaltung <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 4.0 <br />
 * 
 */

package de.javawi.personal;
import java.util.*;

public class Personalverwaltung {  
   private IMitarbeiterData data;

   private Comparator<Mitarbeiter> comp = null;

   public Personalverwaltung(IMitarbeiterData data) {
      this.data = data;
   }
   public void menue() {
      System.out.println("MITARBEITERVERWALTUNG 4.0");
      while( true ) {
         System.out.println("- - - - - - - - -");
         System.out.println("  A (Anzeigen)");
         System.out.println("  B (Bearbeiten)");
         System.out.println("  N (Neu)");
         System.out.println("  L (Lschen)");
         System.out.println("  S (Schlieen)");
         System.out.println("- - - - - - - - -");
         System.out.print("Bitte auswhlen: ");
         // Menauswahl
         String s = new Scanner(System.in).nextLine();
         char c = s.length() == 0 ? ' ' : s.toUpperCase().charAt(0);
         // Aktion
         switch( c ){
         case 'A':
            anzeigen();
            break;
         case 'B':
            bearbeiten();
            break;
         case 'N':
            neu();
            break;
         case 'L':
            loeschen();
            break;
         case 'S':
            System.out.println("Programm beendet.");
            return;
         }
      }
   }

   public void anzeigen() {
      while( true ) {
         List<Mitarbeiter> l = data.findAll();
         if( comp == null )
            Collections.sort(l); 
         else
            Collections.sort(l, comp);
         System.out.println(l);
         System.out.println("- - - - - - - - -");
         System.out.println("  P (Sortieren nach Personalnummer)");
         System.out.println("  N (Sortieren nach Name)");
         System.out.println("  B (Beenden der Anzeige)");
         System.out.println("- - - - - - - - -");
         System.out.print("Bitte auswhlen: ");
         String s = new Scanner(System.in).nextLine();
         char c = s.length() == 0 ? ' ' : s.toUpperCase().charAt(0);
         switch( c ){
         case 'P': // sort nach Personalnummer
            comp = null;
            break;
         case 'N': // sort nach Name
            comp = Mitarbeiter.NAME_ORDER;
            break;
         case 'B':
            return;
         }
      }
   }

   public void bearbeiten() {
      if( data.getCount() == 0 ) {
         System.out.println("Es sind keine Mitarbeiter erfasst.");
         return;
      }
      while( true ) {
         System.out.println(data.findAll());
         System.out.print("Bitte whlen Sie eine Personalnummer aus:");
         try {
            int persNr = new Integer(new Scanner(System.in).nextLine());
            bearbeiten(persNr);
            return;
         } catch( NumberFormatException ne ) {
         }
      }
   }

   public void bearbeiten( int persNr ) {
      boolean modified = false;
      Mitarbeiter m = data.find(persNr);
      if( m == null ) {
         System.out.println("Ein Mitarbeiter mit der Personalnummer " + persNr
               + " existiert nicht.");
         return;
      }
      System.out
            .println("Bitte ndern/besttigen Sie folgende Informationen: ");
      // Nachname
      System.out.print("Nachname [" + m.getNachname() + "]: ");
      String str = new Scanner(System.in).nextLine();
      if( str.length() != 0 ){
         modified = true;
         m.setNachname(str);
      }
      // Vorname
      System.out.print("Vorname [" + m.getVorname() + "]: ");
      str = new Scanner(System.in).nextLine();
      if( str.length() != 0 ){
         modified = true;
         m.setVorname(str);
      }   
      if( modified )
         data.update(m);
   }

   public void neu() {
      int persNr;
      String nachname;
      String vorname;
      int count = 0;
      while( true ) {
         System.out.print("Wieviele Mitarbeiter sollen angelegt werden? [1]: ");
         try {
            String line = new Scanner(System.in).nextLine();
            if( line.length()==0 ){
               count = 1;
               break;
            }
            count = new Integer( line );
            break;
         } catch( NumberFormatException ne ) {
         }
      } 
      if( count<1 )  // nothing to do
         return;
      while( true ) {
         System.out.print("Personalnummer des ersten Mitarbeiters: ");
         try {
            persNr = new Integer(new Scanner(System.in).nextLine());
            break;
         } catch( NumberFormatException ne ) {
         }
      }
      List<Mitarbeiter> l = new ArrayList<Mitarbeiter>();
      System.out.println("Bitte geben Sie folgende Informationen ein: ");
      for( int i=0; i<count; i++ ){
         while( true ) {
            System.out.print("[" + persNr + "] Nachname: ");
            nachname = new Scanner(System.in).nextLine();
            if( nachname.length() > 0 )
               break;
            System.out.println("Leerstring ist nicht erlaubt.");
         }
         while( true ) {
            System.out.print("[" + persNr + "] Vorname: ");
            vorname = new Scanner(System.in).nextLine();
            if( vorname.length() > 0 )
               break;
           System.out.println("Leerstring ist nicht erlaubt.");
         }
         l.add( new Mitarbeiter( persNr++, nachname, vorname ) );
      }
      try{
         data.insert( l );
      } catch( MitarbeiterDataException e){
         System.out.println("Mitarbeiter konnte(n) nicht eingefgt werden: " + e.getMessage());
      }
   }

   public void loeschen() {
      if( data.getCount() == 0 ) {
         System.out.println("Es sind keine Mitarbeiter erfasst.");
         return;
      }
      while( true ) {
         System.out.println(data.findAll());
         System.out.print("Bitte whlen Sie eine Personalnummer aus: ");
         try {
            int persNr = new Integer(new Scanner(System.in).nextLine());
            // existiert Mitarbeiter?
            Mitarbeiter m = data.find(persNr);
            if( m == null ) {
               System.out.println("Ein Mitarbeiter mit der Personalnummer "
                     + persNr + " existiert nicht.");
               return;
            }
            // wirklich lschen?
            System.out.println(m);
            System.out
                  .println("Soll der Mitarbeiter wirklich gelscht werden? [J/N]) ");
            String s = new Scanner(System.in).nextLine();
            char c = s.length() == 0 ? ' ' : s.toUpperCase().charAt(0);
            if( c == 'J' )
               data.delete(persNr);
            else
               System.out.println("Lschen abgebrochen.");
            return;
         } catch( NumberFormatException ne ) { }
      }
   }
}
