/**
 * Titel:     Quelltext zu Kapitel 25: Personalverwaltung <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 4.0 <br />
 * 
 */

package de.javawi.personal;
import java.sql.*;
import java.util.*;


public class MitarbeiterDataHSQLDB implements IMitarbeiterData {
   private static final String driverClass = "org.hsqldb.jdbcDriver";
   private static final String dbUrl = "jdbc:hsqldb:hsql://localhost";
   private static final String dbUser = "sa";
   private static final String dbPasswd = "";

   public MitarbeiterDataHSQLDB()  {
      try {
         Class.forName( driverClass );
      } catch( ClassNotFoundException e ) {
         throw new MitarbeiterDataException( e );
      }
   }
   public void delete( int persNr )  {
      Connection con = null;
      Statement st = null;
      try {
         con = DriverManager.getConnection(dbUrl, dbUser, dbPasswd);
         st = con.createStatement();
         String sql = "DELETE FROM MITARBEITER WHERE PERSNR=" + persNr;
         st.executeUpdate( sql );  
      }
      catch( SQLException e){
         throw new MitarbeiterDataException( e );
      }
      finally{
         if( st!=null ){
            try{ st.close();} catch( SQLException e){ e.printStackTrace(); }
         }
         if( con!=null ){
            try{ con.close();} catch( SQLException e){ e.printStackTrace(); }
         }
      }
   }

   public Mitarbeiter find( int persNr )  {
      Connection con = null;
      Statement st = null;
      ResultSet rs = null;
      try {
         con = DriverManager.getConnection(dbUrl, dbUser, dbPasswd);
         st = con.createStatement();
         String sql = "SELECT * FROM MITARBEITER WHERE PERSNR=" + persNr;
         rs = st.executeQuery( sql );
         Mitarbeiter m = null;
         if( rs.next() ){                        // es existiert mindestens ein Datensatz
            String nachname = rs.getString("NACHNAME");
            String vorname = rs.getString("VORNAME");
            m = new Mitarbeiter( persNr, nachname, vorname );
            if( rs.next() )                      // es existiert mehr als ein Datensatz
               throw new MitarbeiterDataException("Es existieren mehrere Datenstze zur PERSNR=" + persNr);
         }
         return m;
      }
      catch( SQLException e){
         throw new MitarbeiterDataException( e );
      }
      finally{
         if( rs!=null ){
            try{ rs.close();} catch( SQLException e){ e.printStackTrace(); }
         }
         if( st!=null ){
            try{ st.close();} catch( SQLException e){ e.printStackTrace(); }
         }
         if( con!=null ){
            try{ con.close();} catch( SQLException e){ e.printStackTrace(); }
         }
      }
   }

   public List<Mitarbeiter> findAll()  {
      List<Mitarbeiter> l = new ArrayList<Mitarbeiter>();
      Connection con = null;
      Statement st = null;
      ResultSet rs = null;
      try {
         con = DriverManager.getConnection(dbUrl, dbUser, dbPasswd);
         st = con.createStatement();
         String sql = "SELECT * FROM MITARBEITER";
         rs = st.executeQuery( sql );
         
         while( rs.next() ){ 
            int persNr = rs.getInt("PERSNR");
            String nachname = rs.getString("NACHNAME");
            String vorname = rs.getString("VORNAME");
            l.add( new Mitarbeiter( persNr, nachname, vorname ) );
         }
         return l;
      }
      catch( SQLException e){
         throw new MitarbeiterDataException( e );
      }
      finally{
         if( rs!=null ){
            try{ rs.close();} catch( SQLException e){ e.printStackTrace(); }
         }
         if( st!=null ){
            try{ st.close();} catch( SQLException e){ e.printStackTrace(); }
         }
         if( con!=null ){
            try{ con.close();} catch( SQLException e){ e.printStackTrace(); }
         }
      }
   }

   public int getCount()  {
      Connection con = null;
      Statement st = null;
      ResultSet rs = null;
      try {
         con = DriverManager.getConnection(dbUrl, dbUser, dbPasswd);
         st = con.createStatement();
         String sql = "SELECT COUNT(*) FROM MITARBEITER";
         rs = st.executeQuery( sql );
         rs.next();
         int count = rs.getInt(1);
         return count;
      }
      catch( SQLException e){
         throw new MitarbeiterDataException( e );
      }
      finally{
         if( rs!=null ){
            try{ rs.close();} catch( SQLException e){ e.printStackTrace(); }
         }
         if( st!=null ){
            try{ st.close();} catch( SQLException e){ e.printStackTrace(); }
         }
         if( con!=null ){
            try{ con.close();} catch( SQLException e){ e.printStackTrace(); }
         }
      }
   }

   public void insert( Mitarbeiter m )  {
      Connection con = null;
      Statement st = null;
      try {
         con = DriverManager.getConnection(dbUrl, dbUser, dbPasswd);
         st = con.createStatement();
         String sql = "INSERT INTO MITARBEITER VALUES (" + m.getPersNr() + ", '" +
                         m.getNachname() + "', '" + m.getVorname() + "')";
         st.executeUpdate( sql );
      }
      catch( SQLException e){
         throw new MitarbeiterDataException( e );
      }
      finally{
         if( st!=null ){
            try{ st.close();} catch( SQLException e){ e.printStackTrace(); }
         }
         if( con!=null ){
            try{ con.close();} catch( SQLException e){ e.printStackTrace(); }
         }
      }
   }

   public void insert( List<Mitarbeiter> l )  {
      Connection con = null;
      Statement st = null;
      boolean autoCommitPrev=true, autoCommitChanged=false;
      try {
         con = DriverManager.getConnection(dbUrl, dbUser, dbPasswd);
         
         autoCommitPrev = con.getAutoCommit();
         if( autoCommitPrev ){                // gegebenenfalls AutoCommit deaktivieren
            con.setAutoCommit( false );
            autoCommitChanged = true;
         }
         st = con.createStatement();
         for( Mitarbeiter m:l ){
            String sql = "INSERT INTO MITARBEITER VALUES (" + m.getPersNr() + ", '" +
                       m.getNachname() + "', '" + m.getVorname() + "')";
            st.executeUpdate( sql );
         }
         con.commit();
      }
      catch( SQLException e){
         if( con!=null ){
            try{ con.rollback(); } catch( SQLException se ){ e.printStackTrace(); }
         }
         throw new MitarbeiterDataException( e );
      }
      finally{
         if( autoCommitChanged ){
            try{ con.setAutoCommit( autoCommitPrev );} catch( SQLException e ){ e.printStackTrace(); }   
         }
         if( st!=null ){
            try{ st.close();} catch( SQLException e){ e.printStackTrace(); }
         }
         if( con!=null ){
            try{ con.close();} catch( SQLException e){ e.printStackTrace(); }
         }
      }
   }
   public void update( Mitarbeiter m )  {
      Connection con = null;
      Statement st = null;
      try {
         con = DriverManager.getConnection(dbUrl, dbUser, dbPasswd);
         st = con.createStatement();
         String sql = "UPDATE MITARBEITER SET NACHNAME='" + m.getNachname() + "', VORNAME='" +
                       m.getVorname() + "' WHERE PERSNR=" + m.getPersNr();
         st.executeUpdate( sql );
      }
      catch( SQLException e){
         throw new MitarbeiterDataException( e );
      }
      finally{
         if( st!=null ){
            try{ st.close();} catch( SQLException e){ e.printStackTrace(); }
         }
         if( con!=null ){
            try{ con.close();} catch( SQLException e){ e.printStackTrace(); }
         }
      }
   }
}
