/**
 * Titel:     Quelltext zu Kapitel 25: Personalverwaltung <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 1.0 <br />
 * 
 */


package de.javawi.personal;
import java.util.ArrayList;
import java.util.Scanner;

class Personalverwaltung {
   private final ArrayList mListe = new ArrayList();
   public void menue(){
      // einige Testdaten
      mListe.add(new Mitarbeiter(1009, "Meier", "Iris"));
      mListe.add(new Mitarbeiter(1004, "Schmidt", "Ralf"));
      mListe.add(new Mitarbeiter(1010, "Abel", "Inge"));

      System.out.println("MITARBEITERVERWALTUNG 1.0");
      while( true ) {
         System.out.println("- - - - - - - - -");
         System.out.println("  A (Anzeigen)");
         System.out.println("  B (Bearbeiten)");
         System.out.println("  N (Neu)");
         System.out.println("  L (Lschen)");
         System.out.println("  S (Schlieen)");
         System.out.println("- - - - - - - - -");
         System.out.print("Bitte auswhlen: ");
         // Menauswahl
         String s = new Scanner(System.in).nextLine();
         char c = s.length() == 0 ? ' ' : s.toUpperCase().charAt(0);
         // Aktion
         switch( c ){
         case 'A':
            System.out.println(mListe);
            break;
         case 'B':
            System.out.println("Noch nicht implementiert.");
            break;
         case 'N':
            int persNr;
            String nachname;
            String vorname;
            System.out.println("Bitte geben Sie folgende Informationen ein: ");
            while( true ) {
               System.out.print("Personalnummer: ");
               try {
                  persNr = new Integer(new Scanner(System.in).nextLine());
                  break;
               } catch( NumberFormatException ne ) {
               }
            }
            while( true ) {
               System.out.print("Nachname: ");
               nachname = new Scanner(System.in).nextLine();
               if( nachname.length() > 0 )
                  break;
               System.out.println("Leerstring ist nicht erlaubt.");
            }
            while( true ) {
               System.out.print("Vorname: ");
               vorname = new Scanner(System.in).nextLine();
               if( vorname.length() > 0 )
                  break;
               System.out.println("Leerstring ist nicht erlaubt.");
            }
            mListe.add( new Mitarbeiter( persNr, nachname, vorname ));
            break;
         case 'L':
            System.out.println("Noch nicht implementiert.");
            break;
         case 'S':
            System.out.println("Programm beendet.");
            return;
         }
      }
   }
}