/**
 * Titel:     Quelltext zu Kapitel 25: Callcenter <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 1.0 <br />
 * 
 */

package de.javawi.callcenter;
import java.util.*;

public class Agent implements Comparable<Agent> {
	private final int agentID;
	
	private long idle;
	private long work;

	public Agent(int agentID) {
		this.agentID = agentID;
		idle = System.currentTimeMillis();
		work = 0;
	}
	public void setIdle(long idle) {
		this.idle = idle;
	}
	public void setWork(long work) {
		this.work = work;
	}
	public long getIdle(){
		return idle;
	}
	public long getWork(){
		return work;
	}
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null) return false;
		if (getClass() != o.getClass())	return false;
		return this.agentID == ((Agent)o).agentID;
	}
	public int hashCode(){
		return agentID;
	}
	public String toString(){
		return "(A-" + agentID + " idle=" + idle + " work=" + work + ")";
	} 
	public int compareTo( Agent a ){
		return a.agentID<agentID ? -1 : ( a.agentID>agentID ? 1 : 0 );
	}
	public static Comparator<Agent> IDLE_ORDER = new Comparator<Agent>(){
		public int compare( Agent a1, Agent a2 ) {
			return a1.idle<a2.idle ? -1 : ( a1.idle>a2.idle ? 1 : a1.compareTo(a2) );
		}	
	};
	public static Comparator<Agent> WORK_ORDER = new Comparator<Agent>(){
		public int compare( Agent a1, Agent a2 ) {
			return a1.work<a2.work ? -1 : ( a1.work>a2.work ? 1 : a1.compareTo(a2) );
		}	
	};
}
