/**
 * Titel:     Quelltext zu Kapitel 25: Callcenter <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 2.0 <br />
 * 
 */

package de.javawi.callcenter;
import java.util.*;

public class Callcenter extends Thread {
    private IBlockingQueue<Call> callQ = null;
    private IBlockingQueue<Agent> agentQ = null;
    
    private List<Call> callList = new ArrayList<Call>();
    private List<Agent> agentList = new ArrayList<Agent>();
	
	public Callcenter(int n_agents, Comparator<Agent> agentPrio, Comparator<Call> callPrio) {
		
		callQ = new PrioBlockingQueue<Call>( callPrio );
		
		
		// AgentenQueue erzeugen
		agentQ = new PrioBlockingQueue<Agent>(  agentPrio  );
		
		
		// jetzt die Agenten erzeugen und in ihre Queue einfgen
		for( int i=0; i<n_agents; i++){
			   Agent a=new Agent(1000 + i);
		       agentQ.put( a );
		       agentList.add( a );             // for summary
		}	
	}

	public void run() {
		List<Worker> workerList = new ArrayList<Worker>();
		while( true ){
			try{
				Call c = callQ.take();         // einen Call aus der CallQ entnehmen
				
				if( c.isTermCall() )           // Terminator-Call
					break;
				
				callList.add( c );             // for summary
				
				Agent a = agentQ.take();       // ... und einen Agenten aus der AgentQ 
				Worker w = new Worker(a, c, agentQ);
				w.start();                     // ... Gesprch fhren 
				workerList.add( w );
			} catch( InterruptedException e ){ e.printStackTrace(); }
		}
		try{ // alle Worker einsammeln ...
			for( Worker w : workerList )
				w.join();
		}catch( InterruptedException e){ e.printStackTrace();}
		System.out.println("Alle Worker beendet.");
		summary();
	}
	/*public IBlockingQueue<Call> getCallQueue(){
		return callQ;
	}*/
	public void putCallQ( Call c ){
		callQ.put( c );
	}
	public void summary(){
		long work = 0;
		for( Agent a : agentList ){
			work += a.getWork();
		}
      System.out.println();
		System.out.println("AGENTEN            Anzahl: " + agentList.size() );
		System.out.println("  Aktivitt       (Summe): " + work );
		System.out.println("           (Durchschnitt): " + work/agentList.size() );
		System.out.println();
     
		int[] ct = new int[4];
		long[] callT = new long[4];
		long[] waitT = new long[4];

		for( Call c : callList ){
			if( c.isTermCall() ) continue;
			callT[3] += c.getCallT();
			callT[c.getStatus()] += c.getCallT();
			
			long wait = c.getAccepted()-c.getCalled();
			waitT[3] += wait;
			waitT[c.getStatus()] += wait;
				
			ct[3]++;
			ct[c.getStatus()]++;
		}
		System.out.println("CALLS              Anzahl: " + ct[3]);

		System.out.println("  Gesprchszeit   (Summe): " + callT[3] );
		System.out.println("       Durchschn.   (all): " + (callT[3]/ct[3] ));
		System.out.println("                 (PRIVAT): " + (callT[Call.PRIVAT]/ct[Call.PRIVAT] ));
		System.out.println("                 (FIRMEN): " + (callT[Call.FIRMEN]/ct[Call.FIRMEN] ));
		System.out.println("                (PREMIUM): " + (callT[Call.PREMIUM]/ct[Call.PREMIUM] ));
		System.out.println("  Wartezeit       (Summe): " + waitT[3] );
		System.out.println("       Durchschn.   (all): " + (waitT[3]/ct[3] ));
		System.out.println("                 (PRIVAT): " + (waitT[Call.PRIVAT]/ct[Call.PRIVAT] ));
		System.out.println("                 (FIRMEN): " + (waitT[Call.FIRMEN]/ct[Call.FIRMEN] ));
		System.out.println("                (PREMIUM): " + (waitT[Call.PREMIUM]/ct[Call.PREMIUM] ));
		
	}
}
class Worker extends Thread{
	private IBlockingQueue<Agent> agentQ;
	private Call c;
	private Agent a;
	public Worker(Agent a, Call c, IBlockingQueue<Agent> agentQ){
		this.a=a; this.c=c; this.agentQ=agentQ;
	}
	public void run(){
		long start = System.currentTimeMillis();
		c.setAccepted( start );
		try{
			sleep( c.getCallT() );
		}catch( InterruptedException e){}
		long end = System.currentTimeMillis();
		a.setIdle( end );
		a.setWork( a.getWork() + end - start );
		
		// Agenten in die Queue zurckstellen
		agentQ.put(a);
		System.out.println("Beendet: " + a + "  " + c);
	}
}

