/**
 * Titel:     Quelltext zu Kapitel 25: Callcenter <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 2.0 <br />
 * 
 */

package de.javawi.callcenter;

import java.util.*;

public class Call implements Comparable<Call> {
	final static int PRIVAT = 0;
	final static int FIRMEN = 1;
	final static int PREMIUM = 2;
	
	private int callID;
	private int status;
	private int callT;

	private long called;
	private long accepted;
	
	private boolean termCall = false;

	public Call(int callID, int status, int callT) {
		this.callID = callID;
		this.status = status;
		this.callT = callT;
	}
	private Call(){}
	public static Call createTermCall(){
		Call c = new Call();
		c.termCall = true;
		return c;
	}
	public boolean isTermCall(){
		return termCall;
	}

	public int getCallT() {
		return callT;
	}

	public long getCalled() {
		return called;
	}

	public long getAccepted() {
		return accepted;
	}
	public int getStatus() {
		return status;
	}
	
	public void setCalled(long called) {
		this.called = called;
	}

	public void setAccepted(long accepted) {
		this.accepted = accepted;
	}

	public boolean equals(Object o) {
		if (this == o)
			return true;
		if (o == null)
			return false;
		if (getClass() != o.getClass())
			return false;
		return this.callID == ((Call) o).callID; // nur callID relevant
	}

	public int hashCode() {
		return callID;
	}

	public String toString() {
		return "(C-" + callID + " callT=" + callT + " wait="
				+ (accepted - called) + " st=" + status + ")";
	}

	public int compareTo(Call c) {
		return callID < c.callID ? -1 : (callID > c.callID ? 1 : 0);
	}

	public static Comparator<Call> WAITING_ORDER = new Comparator<Call>() {
		public int compare(Call c1, Call c2) {
			return c1.called < c2.called ? -1 : (c2.called < c1.called ? 1 : c1
					.compareTo(c2));
		}
	};

	public static Comparator<Call> STATUS_ORDER = new Comparator<Call>() {
		public int compare(Call c1, Call c2) {
			if( c1.termCall && !c2.termCall ) return 1;   // Sonderfall: terminierender Call
			if( c2.termCall && !c1.termCall ) return -1;  // "           "
			int s1 = c1.status;
			int s2 = c2.status;
			if (s1 != s2) {          // PREMIUM- vor FIRMEN- vor PRIVAT-Kunden
				if (s1 == PREMIUM)   // bei gleichem Status: WAITING_ORDER
					return -1;
				if (s2 == PREMIUM)
					return 1;
				if (s1 == FIRMEN)
					return -1;
				if (s2 == FIRMEN)
					return 1;
			}
			return WAITING_ORDER.compare(c1, c2); // gleicher Status
		}
	};
}
