/**
 * Titel:     Quelltext zu Kapitel 25: Callcenter <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 1.0 <br />
 * 
 */

package de.javawi.callcenter;

import java.util.*;

public class PrioBlockingQueue<T> extends ArrayList<T> implements IBlockingQueue<T> {
	private static final long serialVersionUID = -5365169783585620790L;
	
	private Comparator<T> priority = null;
	
	public PrioBlockingQueue(  Comparator<T> priority ){
		this.priority = priority;
	}
	public synchronized T take() throws InterruptedException {
		while (size() == 0) {
				wait();
		}
		T t = (T)Collections.min( this, priority );
		remove( t );
		return t;
	}

	public synchronized void put(T t) {
		add(t);
		notify();
	}
}

interface IBlockingQueue<T> {
	public T take() throws InterruptedException;
	public void put(T t);
}