/**
 * Titel:     Quelltext zu Kapitel 25: Callcenter <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 1.0 <br />
 * 
 */

package de.javawi.callcenter;
import java.util.*;

public class Callcenter extends Thread {
    private IBlockingQueue<Call> callQ = null;
    private IBlockingQueue<Agent> agentQ = null;
	
	public Callcenter(int n_agents, Comparator<Agent> agentPrio, Comparator<Call> callPrio) {
		
		callQ = new PrioBlockingQueue<Call>( callPrio );
		
		// AgentenQueue erzeugen
		agentQ = new PrioBlockingQueue<Agent>(  agentPrio  );
      
		// jetzt die Agenten erzeugen und in ihre Queue einfgen
		for( int i=0; i<n_agents; i++){
			   Agent a=new Agent(1000 + i);
		       agentQ.put( a ); 
		}	
	}

	public void run() {
		while( true ){
			try{
				Call c = callQ.take();         // einen Call aus der CallQ entnehmen
				Agent a = agentQ.take();       // ... und einen Agenten aus der AgentQ 
				new Worker(a, c, agentQ).start();     // ... Gesprch fhren    	
			} catch( InterruptedException e ){ e.printStackTrace(); }
		}
	}
	public IBlockingQueue<Call> getCallQueue(){
		return callQ;
	}
}
class Worker extends Thread{
	private IBlockingQueue<Agent> agentQ;
	private Call c;
	private Agent a;
	public Worker(Agent a, Call c, IBlockingQueue<Agent> agentQ){
		this.a=a; this.c=c; this.agentQ=agentQ;
	}
	public void run(){
		long start = System.currentTimeMillis();
		c.setAccepted( start );
		try{
			sleep( c.getCallT() );
		}catch( InterruptedException e){}
		long end = System.currentTimeMillis();
		a.setIdle( end );
		a.setWork( a.getWork() + end - start );
		
		// Agenten in die Queue zurckstellen
		agentQ.put(a);
		System.out.println("Beendet: " + a + "  " + c);
	}
}
