/**
 * Titel:     Quelltext zu Kapitel 25: Callcenter <br />
 * Buch:      Grundkurs-Java fr Wirtschaftsinformatiker. Vieweg 2007. <br />
 * Autoren:   Klaus-Georg Deck und Herbert Neuendorf
 * Copyright: Copyright (c) 2007 <br />
 * 
 * @author Klaus-Georg Deck<br />
 * @version 1.0 <br />
 * 
 */

package de.javawi.callcenter;

public class CallCreator extends Thread{
	private IBlockingQueue<Call> q;
    private CallParams p;
	
	public CallCreator( Callcenter c, CallParams p ){
		this.q=c.getCallQueue(); this.p=p;
	}
	public void run(){
	   int n = p.getN_calls();
	   for(int i=0; i != n ; i++){   // cave: infinite-loop for n_Calls==-1
		   
		  // callT: Dauer des Gesprchs in Millisekunden
		  // zuflliger Wert zwischen p.getMin_callT (Sekunden) und p.getMax_callT (Sekunden) 
		  int callT = p.getMin_callT() * 1000;
		  if( p.getMax_callT()!=p.getMin_callT() )
			  callT += (int)(Math.random()*1000) * (p.getMax_callT()-p.getMin_callT()) ;	

		  // status: PREMIUM, FIRMEN, PRIVAT-Kunde
		  int status = i%3;
		  // Call erzeugen
		  Call c = new Call( 1000+i, status, callT );
		  
		  // Anrufzeit registrieren
		  c.setCalled( System.currentTimeMillis() );
		  
		  // in die Queue stellen
          q.put( c );
          
          // nexT: Zeit bis nchster Call erzeugt wird (in Millisekunden)
          int nextT = p.getMin_nextT()*1000;
          if( p.getMin_nextT()!=p.getMax_nextT())
             nextT += (int)(Math.random()*1000) * (p.getMax_nextT()-p.getMin_nextT()) ;

          // schlafen und dann weiter	
		  try{sleep(nextT);}catch(InterruptedException e){}
	   }
	}
}

class CallParams {
	private int n_calls;
	private int min_callT;
	private int max_callT;
	private int min_nextT;
	private int max_nextT;
	public CallParams(int n_calls, int min_callT, int max_callT, int min_nextT , int max_nextT){
	   if( n_calls < -1 )
		   throw new IllegalArgumentException("Falscher Parameterwert: n_calls=" + n_calls);
	   if( min_callT > max_callT )
		   throw new IllegalArgumentException("Fehler beim Intervall fr callT: [" + min_callT + ", " + max_callT + "]");
	   if( min_nextT > max_nextT )
		   throw new IllegalArgumentException("Fehler beim Intervall fr nextT: [" + min_nextT + ", " + max_nextT + "]");
       this.n_calls=n_calls; this.min_callT=min_callT; this.max_callT=max_callT; this.min_nextT=min_nextT; this.max_nextT=max_nextT;		
	}
	public int getMax_callT() {
		return max_callT;
	}
	public void setMax_callT(int max_callT) {
		this.max_callT = max_callT;
	}
	public int getMax_nextT() {
		return max_nextT;
	}
	public void setMax_nextT(int max_nextT) {
		this.max_nextT = max_nextT;
	}
	public int getMin_callT() {
		return min_callT;
	}
	public void setMin_callT(int min_callT) {
		this.min_callT = min_callT;
	}
	public int getMin_nextT() {
		return min_nextT;
	}
	public void setMin_nextT(int min_nextT) {
		this.min_nextT = min_nextT;
	}
	public int getN_calls() {
		return n_calls;
	}
	public void setN_calls(int n_calls) {
		this.n_calls = n_calls;
	}

}
